// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

/*
|==========||==========|
GS Shader 2.1

By Goldshadow12
|==========||==========|
*/


#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300
	#ifndef BYPASS_PIXEL_SHADER
		#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
			_centroid in highp vec2 uv0;
			_centroid in highp vec2 uv1;
		#else
			_centroid in vec2 uv0;
			_centroid in vec2 uv1;
		#endif
	#endif
#else
	#ifndef BYPASS_PIXEL_SHADER
		in vec2 uv0;
		in vec2 uv1;
	#endif
#endif

in vec4 color;
in highp vec3 position;
in highp vec3 wPos;
in vec3 screen_pos;
in float new_fog;

in highp vec3 look_vector;

in float vignette;

#ifdef UNWATER
    in vec4 fogColor;
#endif

#include "uniformShaderConstants.h"
#include "uniformPerFrameConstants.h"
#include "util.h"

#include "lib/terrain.h"
#include "lib/boolean.h"
#include "lib/water.h"
#include "lib/presets.h"

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;
LAYOUT_BINDING(1) uniform sampler2D TEXTURE_1;
LAYOUT_BINDING(2) uniform sampler2D TEXTURE_2;

vec3 Torch( vec3 clr, vec3 rc ){
    
    vec3 color;
    
    #ifdef UNWATER
    color = mix(vec3(.0,.25,.7)*1.5, clr, .5);
    #else
    color = mix(vec3(.7,.25,.0)*1.5, clr, .5);
    #endif
    
    const float wbalance = .05;
    
    color = mix(color, vec3(1.), vec3(wbalance));
    
    color = pow(color, vec3(.99));
    
    return color * dot(color, vec3(1.));
}


vec3 Shadows( in vec3 diff, in vec4 color, in float tn ){
    
    vec3 n = normalize(cross(dFdx(position.gbr), dFdy(position.gbr)));
    
    vec4 ns = vec4(1.-uv1.x,.8810,.0,.0);
    
    float iN = mix(.5,.2,tn);
    #ifdef ALPHA_TEST
        if(color.a == .0){
            diff *= 1.4; ns.t = .8749;
            ns.p = GetShadow(ns.p,iN,-n.s,n.p)*uv1.y;
        }else{
            ns.p = .0,ns.w = .0;
        }
    #else
        #if !defined (BLEND)
            ns.p = GetShadow(ns.p,iN,-n.s,n.p)*uv1.y;
        #endif
    #endif
    
    #if !defined(BLEND)
        float dL = DIRLIGHT == ON ? ns.p : 0.;
        ns.p = SHADOW == OFF ? .0 : mix(dL,iN,smoothstep(ns.t-.0005,ns.t-.0050,uv1.y));
        if(DIRLIGHT == ON || SHADOW == ON)diff = mix(diff, vec3(.0), max(ns.p,dL)*ns.s);

    #endif
    
    return diff;
}

vec4 CalcWaterWave( in vec4 diff, in vec3 timedet, in vec3 gradcolor ){
    
    float fdis = length(wPos.xz)/FAR_CHUNKS_DISTANCE;
    
    highp float Wave = Waves(position);
    
        vec3 clr = vec3(.1,.3,.5)*.8;
        vec4 fwater = vec4(clr,mix(.7,.5,Wave));
        
        fwater.rgb = mix(fwater.rgb, gradcolor, clamp(pow(fdis,1.5),.0,1.));
        fwater.rgb = mix(fwater.rgb, gradcolor, clamp(pow(fdis,4.)*1.1,.0,1.));
        
        fwater.a += pow(fdis,7.);
        
        diff = WATER == OFF ? diff*color : fwater;
    
    return diff;
    
}

vec3 CalcUnEffect( in vec3 diff ){
    
    vec3 caustic = diff;
    highp float wv = Waves(position);
    const float c = CausticIntensity;
    caustic = mix(caustic, caustic * vec3(c) * (1.-uv1.x), (1.-wv)*uv1.y);
    
    caustic = CAUSTIC == ON ? caustic : diff;
    
    return caustic;
}

vec3 GetWorldColor( in vec3 diff, in vec3 timedet, in float det ){
    
    if(det == 1.){
        vec3 final = mix(mix(mix(mix(vec3(1.1), vec3(.2,.4,1.)*.3, timedet.s), vec3(.5), timedet.t), GetGrayscale(vec3(.6),.3), timedet.p), vec3(.5), 1.-uv1.y);
        return diff * final;
    }else{
        vec3 final = mix(mix(mix(vec3(1.1)*diff, vec3(.2,.4,1.)*.4, timedet.s), vec3(.7,.6,.3)*diff, timedet.t), diff, timedet.p); 
        return final;
    }
}

void main() {

    #ifdef BYPASS_PIXEL_SHADER
	    gl_FragColor = vec4(0, 0, 0, 0);
	    return;
    #else
    
    float ef = mix(1.,1.7,uv1.y);
    
    #if USE_TEXEL_AA
	    vec4 diffuse = texture2D_AA(TEXTURE_0, uv0);
	    vec4 light_ = texture2D_AA(TEXTURE_1, vec2(uv1.x*.5,uv1.y*ef));
        vec4 li = texture2D_AA( TEXTURE_1, vec2(.0,1.));

    #else
	    vec4 diffuse = texture2D(TEXTURE_0, uv0);
	    vec4 light_ = texture2D(TEXTURE_1, vec2(uv1.x*.5,uv1.y*ef));
        vec4 li = texture2D( TEXTURE_1, vec2(.0,1.));
    #endif
    
  vec4 fc = FOG_COLOR;
    
    vec3 bdiff = diffuse.rgb*color.rgb;

    vec3 timedetect = vec3(max(1.-min(pow(li.r*1.8,5.),1.),.0),pow(clamp((1.-pow(li.r,5.))*1.3,.0,1.),8.),clamp((1.-pow(FOG_CONTROL.y,11.)),.0,1.))*uv1.y;
    
    float tBias = mix(mix(mix(.0,.6,timedetect.t),1.,timedetect.s),1.,1.-uv1.y);
    
    float watde = .0;
    
    #ifdef ALPHA_TEST
        if(diffuse.a < .5)discard;
    #endif


    #if !defined(ALWAYS_LIT)
	    diffuse *= light_;
    #endif

    #ifndef SEASONS
        #if !USE_ALPHA_TEST && !defined(BLEND)
            diffuse.a = color.a;
        #endif
 
	    const vec3 Ambient = vec3(.1);
	    
	    diffuse.rgb += mix(vec3(.0), Ambient*diffuse.rgb, 1.-pow(uv1.x, 4.));
	    

    GetAo(diffuse.rgb,color,uv1.y);
  


    #endif

    vec3 WorldColor = GetWorldColor(diffuse.rgb,timedetect,1.);
    vec3 WorldFogColor = GetWorldColor(fc.rgb,timedetect,.0);
    if(GetWater(color)){
        #if !defined(ALPHA_TEST) && !defined(SEASONS)
            watde = 1.;
            diffuse = CalcWaterWave(diffuse,timedetect,WorldFogColor)*light_;
        #endif
    }else{
        diffuse.rgb = Contrast(tone(WorldColor),.8);
    }
    

    
    diffuse.rgb = HDR(diffuse.rgb);
    diffuse.rgb = Shadows(diffuse.rgb,color,timedetect.s);
    diffuse.rgb += mix(vec3(.0), Torch(bdiff, color.rgb )*tBias, pow(uv1.x,4.));
    
    if(watde != 1.){
        #if !defined (UNWATER)
        diffuse.rgb = mix(diffuse.rgb, WorldFogColor, mix(new_fog, new_fog*2., timedetect.p));
        #else
        diffuse.rgb = CalcUnEffect(diffuse.rgb);
        #endif
    }

   
    
    #ifdef UNWATER
        diffuse.rgb = mix(diffuse.rgb, fogColor.rgb, pow(fogColor.a,2.));
    #endif
    
	gl_FragColor = diffuse;
	
    #endif
}
